import pygame
from config import LARGURA_JANELA, ALTURA_JANELA, COMPRIMENTO_NIVEL
from placar import ler_tempos, salvar_tempo


""" Máquina de estados do jogo """


class EstadoJogo:
    def __init__(self, caminho_tempos: str):
        self.estado = "inicio"
        self.cronometro_inicio_ms: int | None = None 
        self.cronometro_ativo = False
        self.tempo_decorrido_ms = 0
        self.tempo_final_ms: int | None = None
        self.nome_jogador = ""
        self.nome_salvo = False
        self.registros = ler_tempos(caminho_tempos)
        self.zona_final_x = COMPRIMENTO_NIVEL - 200

    def iniciar_jogo(self):
        self.estado = "jogando"
        self.cronometro_inicio_ms = pygame.time.get_ticks()
        self.cronometro_ativo = True

    def finalizar_jogo(self):
        self.estado = "final"
        self.cronometro_ativo = False
        self.tempo_final_ms = self.tempo_decorrido_ms

    def reiniciar(self):
        self.estado = "inicio"
        self.cronometro_inicio_ms = None
        self.cronometro_ativo = False
        self.tempo_decorrido_ms = 0
        self.tempo_final_ms = None
        self.nome_jogador = ""
        self.nome_salvo = False

    def atualizar_cronometro(self):
        if self.cronometro_ativo and self.cronometro_inicio_ms is not None:
            agora = pygame.time.get_ticks()
            self.tempo_decorrido_ms = agora - self.cronometro_inicio_ms

    def processar_entrada_inicio(self, evento: pygame.event.Event):
        if evento.type == pygame.KEYDOWN:
            self.iniciar_jogo()

    def processar_entrada_final(self, evento: pygame.event.Event, caminho_tempos: str):
        if evento.type == pygame.KEYDOWN:
            if evento.key == pygame.K_RETURN and self.nome_jogador.strip():
                if self.tempo_final_ms is not None and not self.nome_salvo:

