import os
import sys
import pygame
from config import LARGURA_JANELA, ALTURA_JANELA, QUADROS_POR_SEGUNDO, COMPRIMENTO_NIVEL
from util_imagem import carregar_imagem
from camera import Camera
from jogador import Jogador
from inimigo import Inimigo, Inimigo2
from cenario import construir_cenario
from estado import EstadoJogo
from ui import desenhar_grade, botao_reiniciar_topo, tela_inicio, hud_tempo, tela_final


def criar_jogo(dir_arquivos: str):
    """Cria todas as entidades do jogo"""
    solidos, decoracoes = construir_cenario(dir_arquivos, ALTURA_JANELA, COMPRIMENTO_NIVEL
    jogador = Jogador(posicao_inicial=(100, ALTURA_JANELA - 200), dir_arquivos=dir_arquivos
    inimigos = [
        Inimigo((900, ALTURA_JANELA - 160), dir_arquivos, (780, 980)),
        Inimigo2((1300, ALTURA_JANELA - 160), dir_arquivos, (1200, 1500)),
        Inimigo((1850, ALTURA_JANELA - 160), dir_arquivos, (1750, 2000)),
        Inimigo2((2400, ALTURA_JANELA - 160), dir_arquivos, (2250, 2550)),
        Inimigo((3100, ALTURA_JANELA - 160), dir_arquivos, (2950, 3300)),
        Inimigo2((3750, ALTURA_JANELA - 160), dir_arquivos, (3600, 3900)),
        Inimigo((4450, ALTURA_JANELA - 160), dir_arquivos, (4300, 4550)),
        Inimigo2((5200, ALTURA_JANELA - 160), dir_arquivos, (5050, 5350)),
        Inimigo2((5600, ALTURA_JANELA - 160), dir_arquivos, (5500, 5800)),
        Inimigo((5900, ALTURA_JANELA - 160), dir_arquivos, (5850, 6000)),
    ]
    camera = Camera(largura=COMPRIMENTO_NIVEL, altura=ALTURA_JANELA, largura_janela=LARGURA
    return solidos, decoracoes, jogador, inimigos, camera


def processar_colisoes(jogador: Jogador, inimigos: list, estado: EstadoJogo):
    """Processa colisões entre jogador e inimigos"""
    if estado.estado == "jogando":
        for inimigo in list(inimigos):
            if jogador.retangulo.colliderect(inimigo.retangulo):
                # Se pisar em cima, remove inimigo; senão, reinicia jogador
                if jogador.velocidade_y > 0 and jogador.retangulo.bottom <= inimigo.retangulo
                    inimigo.retangulo.topleft = (COMPRIMENTO_NIVEL + 1000, -1000)
                    try:
                        inimigos.remove(inimigo)
                    except ValueError:
                        pass
                    jogador.velocidade_y = -12
                else:
                    jogador.retangulo.topleft = (100, ALTURA_JANELA - 200)
                    jogador.velocidade_x = 0
                    jogador.velocidade_y = 0


def renderizar_cenario(tela: pygame.Surface, camera: Camera, solidos: list, decoracoes: list
    """Renderiza o cenário (fundo, nuvens, decorações, chão)"""
    cor_ceu = (135, 206, 235)
    tela.fill(cor_ceu)
    
    # Nuvens com paralaxe
    if img_nuvens:
        for x, y in nuvens:
            tela.blit(img_nuvens, (x - int(camera.deslocamento_x * 0.5), y))
    
    # Grade de referência
    desenhar_grade(tela, camera.deslocamento_x, COMPRIMENTO_NIVEL, ALTURA_JANELA)
    
    # Decorações (tijolos, canos)
    for img, ret in decoracoes:
        tela.blit(img, camera.aplicar(ret))
    
    # Chão (barra verde)
    cor_chao = (60, 179, 113)
    for solido in solidos:
        if solido.height >= 64 and solido.width > 500:
            pygame.draw.rect(tela, cor_chao, camera.aplicar(solido))

