import os
import pygame
from util_imagem import carregar_imagem
""" Inimigos com patrulha horizontal """
class Inimigo(pygame.sprite.Sprite):
    def __init__(self, posicao_inicial: tuple[int, int], dir_arquivos: str, limites_patrulha: tuple[int, int]):
        super().__init__()
        caminho_planta = os.path.join(dir_arquivos, "Piranha Plant.png")
        self.imagem = carregar_imagem(caminho_planta, altura_escala=64)
        self.retangulo = self.imagem.get_rect(topleft=posicao_inicial)
        self.direcao = 1
        self.velocidade = 2
        self.limites_patrulha = limites_patrulha

    def patrulhar(self):
        esquerdo, direito = self.limites_patrulha
        self.retangulo.x += self.direcao * self.velocidade
        if self.retangulo.left <= esquerdo:
            self.retangulo.left = esquerdo
            self.direcao = 1
        elif self.retangulo.right >= direito:
            self.retangulo.right = direito
            self.direcao = -1

class Inimigo2(Inimigo):
    def __init__(self, posicao_inicial: tuple[int, int], dir_arquivos: str, limites_patrulha: tuple[int, int]):
        super().__init__(posicao_inicial, dir_arquivos, limites_patrulha)
        caminho_img = os.path.join(dir_arquivos, "inimigo2.jpeg")
        self.imagem = carregar_imagem(caminho_img, altura_escala=80)
        base = self.retangulo.bottomleft
        self.retangulo = self.imagem.get_rect()
        self.retangulo.bottomleft = base
        self.velocidade = 3